/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantInfoQueryResponse;
import com.fshows.leshuapay.sdk.response.merchant.MerchantNolegaSignApplyResponse;
import lombok.Data;

/**
 *
 *
 * @author weikunpeng
 * @version MerchantNolegaSignApplyRequest.java, v 0.1 2025-08-07 15:53 weikunpeng
 */
@Data
public class MerchantNolegaSignApplyRequest extends LeshuaBizRequest<MerchantNolegaSignApplyResponse> {

    /**
     * 乐刷商户号
     */
    private String merchantId;

    /**
     * 银行卡号，必填
     */
    private String bankCardAccount;

    /**
     * 银行卡开户人姓名，必填
     */
    private String bankCardHolder;

    /**
     * 联行号，必填
     */
    private String unionpayCode;

    @Override
    public Class<MerchantNolegaSignApplyResponse> getResponseClass() {
        return MerchantNolegaSignApplyResponse.class;
    }
}