/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;

import java.util.Map;

/**
 * 乐刷活动报名
 *
 * @author zhangmj
 * @version LeshuaActivitySignClient.java, v 0.1 2022-03-08 下午9:17 zhangmj
 */
public interface LeshuaGoldActivitySignClient {

    /**
     * 活动报名
     *
     * @param request
     * @param <T>
     * @return
     * @throws LeshuaException
     */
    <T> LeshuaBaseResponse<T> execute(LeshuaBizRequest<T> request, String url) throws Exception;


    /**
     * 活动报名
     *
     * @param request
     * @param <T>
     * @return
     * @throws LeshuaException
     */
    <T> LeshuaBaseResponse<T> execute(LeshuaBizRequest<T> request, Map<String,String> heads, String url) throws Exception;
}