/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.util.risksign;

import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.request.merchant.riskmanagement.RiskCommitRequest;
import com.fshows.leshuapay.sdk.util.SignUtil;
import com.fshows.leshuapay.sdk.util.risksign.LeshuaRiskSign;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiskCommitSign
implements LeshuaRiskSign {
    private static final Logger log = LoggerFactory.getLogger(RiskCommitSign.class);

    @Override
    public LeshuaBizRequest doSign(Serializable request, String privateKey, String agentId) throws LeshuaException {
        try {
            RiskCommitRequest riskCommitRequest = null;
            if (request instanceof RiskCommitRequest) {
                riskCommitRequest = (RiskCommitRequest)request;
                StringBuffer key = this.getStringBuffer(privateKey, riskCommitRequest);
                riskCommitRequest.setSign(SignUtil.doSign(key.toString()));
            }
            return riskCommitRequest;
        }
        catch (Exception e) {
            log.error("RiskCommitSign->> doSign \u7b7e\u540d\u5f02\u5e38,ex={}", (Throwable)e);
            throw new LeshuaException("\u98ce\u63a7\u7b7e\u540d\u5f02\u5e38", e);
        }
    }

    private StringBuffer getStringBuffer(String privateKey, RiskCommitRequest riskCommitRequest) {
        StringBuffer key = new StringBuffer(riskCommitRequest.getMerchantId());
        key.append("&");
        key.append(riskCommitRequest.getTicketNumber());
        key.append("&");
        key.append(riskCommitRequest.getAppealMaterial());
        key.append("&");
        key.append(privateKey);
        return key;
    }
}

