/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 查询授权openid
 *
 * @author xiaotian
 * @version LeshuaQueryOpenIdRequest.java, v 0.1 2020-07-29 16:40
 */
@Data
public class LeshuaQueryUpserIdRequest extends LeshuaBasePayRequest {

    /**
     * 接口名
     */
    private String service = "query_userid";

    /**
     * 商户id
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 乐刷分配的商户号
     **/
    @NotBlank(message = "userAuthCode不能为空")
    private String userAuthCode;

    /**
     * 收款方识别HTTP请求User Agent中包含银联支付标识，格式为“UnionPay/<版本号> <App标识>”，注意APP标识仅支持字母和数字。
     * 云闪付app支付不填,云闪付外app必填。示例：UnionPay/1.0 ICBCeLife
     */
    private String appUpIdentifier;
}

