/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantSetWithdrawFeeResponse;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;

/**
 * 商户账户提现费率设置 request
 *
 * @author linzy
 * @version MerchantSetWithdrawFeeRequest.java, v 0.1 2023-02-14 17:50 linzy
 */
@Data
public class MerchantSetWithdrawFeeRequest extends LeshuaBizRequest<MerchantSetWithdrawFeeResponse> {

    private static final long serialVersionUID = 1892103059177918416L;

    /**
     * 乐刷商编
     */
    @NotBlank(message = "乐刷商编不能为空")
    private String merchantId;

    /**
     * 提现费率类型
     * D0：提现秒到费率
     * D1：提现次日到费率
     */
    @NotBlank(message = "提现费率类型不能为空")
    private String cashOutType;

    /**
     * 提现费率生效方式
     * 0：立即生效
     * 2：次日生效
     */
    private Integer effectiveType;

    /**
     * 提现费率（低精度），整数。
     * 20代表0.2%
     */
    private Integer fee;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantSetWithdrawFeeResponse> getResponseClass() {
        return MerchantSetWithdrawFeeResponse.class;
    }
}
