package com.fshows.leshuapay.sdk.request.repayment;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.repayment.LeshuaRepaymentResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 乐刷重打款请求参数
 */
@Data
public class LeshuaRepaymentRequest extends LeshuaBizRequest<LeshuaRepaymentResponse> {

    private static final long serialVersionUID = 4425030094985255482L;
    /**
     * 商户打款单编号
     * @required
     */
    @NotBlank(message = "billId不能为空")
    private String billId;

    /**
     * 乐刷商户号
     * @required
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<LeshuaRepaymentResponse> getResponseClass() {
        return LeshuaRepaymentResponse.class;
    }
} 