package com.fshows.leshuapay.sdk.request.repayment;

/**
 * @author songjian * @version LeshuaRepaymentQueryRequest.java, v 0.1 2025-04-17 14:30 songjian
 */

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.repayment.LeshuaRepaymentQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.Pattern;

/**
 * 重打款查询请求参数
 */
@Data
public class LeshuaRepaymentQueryRequest extends LeshuaBizRequest<LeshuaRepaymentQueryResponse> {
    private static final long serialVersionUID = 6883098335778435994L;
    /**
     * 申请开始时间（格式：YYYY-MM-DD）
     */
    @Pattern(regexp = "^\\d{4}-\\d{2}-\\d{2}$", message = "日期格式必须为YYYY-MM-DD")
    private String startTime;

    /**
     * 申请结束时间（格式：YYYY-MM-DD）
     */
    @Pattern(regexp = "^\\d{4}-\\d{2}-\\d{2}$", message = "日期格式必须为YYYY-MM-DD")
    private String endTime;

    /**
     * 商户打款单编号
     */
    private String billId;

    /**
     * 乐刷商户号（10位数字）
     */
    @Pattern(regexp = "^\\d{10}$", message = "merchantId必须为10位数字")
    private String merchantId;

    /**
     * 重打款申请单号（乐刷生成）
     */
    private String applicationId;

    /**
     * 申请状态（0-已重打款，1-待重打款，空-全部）
     */
    @Range(min = 0, max = 1, message = "applicationStatus取值范围0-1")
    private Integer applicationStatus;

    /**
     * 分页参数（必填）
     */
    @Valid
    private PageRequest page;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<LeshuaRepaymentQueryResponse> getResponseClass() {
        return LeshuaRepaymentQueryResponse.class;
    }
}