package com.fshows.leshuapay.sdk.enums;

import cn.hutool.core.util.StrUtil;

/**
 * @author weikunpeng * @version MerchantSignEnum.java, v 0.1 2025-08-07 14:57 weikunpeng
 */
public enum MerchantSignEnum {
    NOLEGAL_SIGN_APPLAY("非法人协议申请", "/unincorporatedEProtocol/apply"),
    NOLEGAL_SIGN_QUERY("非法人协议查询", "/unincorporatedEProtocol/query"),
    ;

    private String name;
    private String value;

    MerchantSignEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static MerchantSignEnum getByValue(String value) {
        MerchantSignEnum[] valueList = MerchantSignEnum.values();
        for (MerchantSignEnum v : valueList) {
            if (StrUtil.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}