/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.expired;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.expired.MerchantCardExpiredListResponse;
import com.fshows.leshuapay.sdk.response.merchant.expired.MerchantCardExpiredQueryResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 商户支付参数查询request
 *
 * @author zhaoyi
 * @version MerchantWxPayConfigQueryRequest.java, v 0.1 2020-07-29 14:50 zhaoyi
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MerchantCardExpiredListQueryRequest extends LeshuaBizRequest<MerchantCardExpiredListResponse> {

    private static final long serialVersionUID = -6585834487758669600L;
    /**
     * 类型
     * 1-法人，2-非法人
     */
    @NotBlank(message = "certificateType能为空")
    @Length(max = 1, message = "certificateType超长")
    private String certificateType;

    /**
     * 证件有效期-查询开始时间
     * 2024-12-01
     */
    @NotBlank(message = "certificateValidDateStart能为空")
    @Length(max = 10, message = "certificateValidDateStart超长")
    private String certificateValidDateStart;

    /**
     * 证件有效期-查询结束时间
     * 2025-03-01
     */
    @NotBlank(message = "certificateValidDateEnd能为空")
    @Length(max = 10, message = "certificateValidDateEnd超长")
    private String certificateValidDateEnd;

    /**
     * 分页开始页码（从1开始），默认为1
     */
    @NotNull(message = "page不能为空")
    private Integer page;


    @Override
    public Class<MerchantCardExpiredListResponse> getResponseClass() {
        return MerchantCardExpiredListResponse.class;
    }

}
