/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.share;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangyi
 * @version CreateSumAccreditResponse.java, v 0.1 2022-05-19 14:50
 */
@Data
public class CreateSumAccreditResponse implements Serializable {

    private static final long serialVersionUID = -6189162411208902758L;

    /**
     * 调用方标注这次汇总分账标识id
     */
    private String thirdId;

    /**
     * 汇总分账总金额
     */
    private String amount;

    /**
     * 乐刷分账id
     */
    private String leshuaId;

    /**
     * sign
     */
    private String sign;

    /**
     * 备注
     */
    private String remark;

    /**
     * 分账详情
     */
    private String details;

    /**
     * 乐刷商户号（汇总分账主体商户）
     */
    private String merchantId;

    /**
     * 错误信息
     */
    private String retmsg;

    /**
     * 错误码
     * 0正常返回
     */
    private String retcode;

    /**
     * 汇总分账状态
     * 0 汇总分账中
     * 1 汇总分账成功
     * 2 汇总分账失败
     * 3 汇总分账撤销中
     * 4 汇总分账撤销成功
     * 5 汇总分账撤销失败
     */
    private String status;
}
