/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.share;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.CreateAccountAccreditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author mengqf
 * @version CreateAccountAccreditRequest.java, v 0.1 2024-08-19 15:35 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class CreateAccountAccreditRequest extends LeshuaBizRequest<CreateAccountAccreditResponse> {

    /**
     * 分账发起方商户编号
     */
    private String merchantId;

    /**
     * 第三方分账编号
     */
    private String thirdId;

    /**
     * 分账总金额
     */
    private String amount;

    /**
     * 分账备注
     */
    private String remark;

    /**
     * 分账手续费计费方式
     * 0：内扣
     * 注：当前仅支持内扣模式
     */
    private String chargeType;

    /**
     * 分账列表
     */
    private String details;

    @Override
    public Class<CreateAccountAccreditResponse> getResponseClass() {
        return CreateAccountAccreditResponse.class;
    }
}