/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant.riskmanagement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.riskmanagement.RiskWorkQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author ruanzeyang
 * @version RiskWorkQueryRequest.java, v 0.1 2021-12-08 16:51 ruanzeyang
 */
@Data
public class RiskWorkQueryRequest extends LeshuaBizRequest<RiskWorkQueryResponse> {

    /**
     * 商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String merchantId;

    /**
     * 风控工单ID
     */
    @NotBlank(message = "风控工单ID不能为空")
    private String ticketNumber;

    /**
     * 是否申诉上游失败 0 是，1否
     */
    @NotBlank(message = "申诉状态不能为空")
    private String appealFail;

    @Override
    public Class<RiskWorkQueryResponse> getResponseClass() {
        return RiskWorkQueryResponse.class;
    }
}