/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.share;

import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.annotation.JSONType;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.CancelSumAccreditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author mengqf
 * @version CancelSumAccreditRequest.java, v 0.1 2025-10-29 15:58 mengqf
 */
@EqualsAndHashCode(callSuper = true)
@Data
@JSONType(naming = PropertyNamingStrategy.SnakeCase)
public class CancelSumAccreditRequest extends LeshuaBizRequest<CancelSumAccreditResponse> {
    /**
     * 服务名称，本处固定为：balance_allot_cancel
     */
    private String cmd = "balance_allot_cancel";

    /**
     * 分账方的乐刷商户编号
     */
    private String merchantId;

    /**
     * 商户分账单号
     */
    private String thirdId;

    @Override
    public Class<CancelSumAccreditResponse> getResponseClass() {
        return CancelSumAccreditResponse.class;
    }
}