/**
 * fshows.com Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.riskmanagement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.riskmanagement.RiskDetailResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 风控详情查询
 *
 * @author chenll
 * @version MerchantSettleRequest.java, v 0.1 2020-07-27 11:50 chenll
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RiskDetailRequest extends LeshuaBizRequest<RiskDetailResponse> {

    /** 商户编号 */
    private String merchantId;

    /** 工单编号 */
    private String ticketNumber;

    /** sign值 */
    private String sign;

    @Override
    public Class<RiskDetailResponse> getResponseClass() {
        return RiskDetailResponse.class;
    }
}
