/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 回调支付状态枚举
 *
 * @author zhaoyi
 * @version PayCallbackStatusEnum.java, v 0.1 2020-08-03 15:25 zhaoyi
 */
public enum PayCallbackStatusEnum {
    PAYING(0, "支付中"),
    PAY_SUCCESS(2, "支付成功"),
    ORDER_CLOSED(6, "订单关闭"),
    PAY_FAILED(8, "支付失败"),
    REFUNDING(10, "退款中"),
    REFUND_SUCCESS(11, "退款成功"),
    REFUND_FAILED(12, "退款成功"),
    ;

    private Integer type;
    private String desc;

    PayCallbackStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static PayCallbackStatusEnum getByType(Integer type) {
        PayCallbackStatusEnum[] valueList = PayCallbackStatusEnum.values();
        for (PayCallbackStatusEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
