/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.client.LeshuaRiskClient;
import com.fshows.leshuapay.sdk.enums.RiskApiEnum;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.util.LeshuaSignature;
import com.fshows.leshuapay.sdk.util.ReqSerialNoUtil;
import com.fshows.leshuapay.sdk.util.ValidateUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaRiskClientImpl
implements LeshuaRiskClient {
    private static final Logger log = LoggerFactory.getLogger(LeshuaRiskClientImpl.class);
    private static final int CONNECTION_REQUEST_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 6000;
    private static final String VERSION = "1.0";
    private String serverUrl;
    private String agentId;
    private String privateKey;
    private Integer timeout;

    public LeshuaRiskClientImpl(String serverUrl, String agentId, String privateKey, Integer timeout) {
        this.serverUrl = serverUrl;
        this.agentId = agentId;
        this.privateKey = privateKey;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> LeshuaBaseResponse<T> execute(LeshuaBizRequest<T> request, RiskApiEnum riskApiEnum, String url, Integer timeout) throws LeshuaException {
        LeshuaBaseResponse<Object> leshuaBaseResponse;
        ValidateUtil.validateWithThrow(request, new Class[0]);
        RequestConfig requestConfig = null;
        requestConfig = timeout == null || timeout <= 0 ? RequestConfig.custom().setConnectionRequestTimeout(5000).setSocketTimeout(10000).setConnectTimeout(6000).build() : RequestConfig.custom().setConnectionRequestTimeout(timeout.intValue()).setSocketTimeout(timeout.intValue()).setConnectTimeout(timeout.intValue()).build();
        HttpPost httpPost = new HttpPost(this.serverUrl + url);
        httpPost.setConfig(requestConfig);
        request = riskApiEnum.getRiskApiSign().doSign(request, this.privateKey, this.agentId);
        StringEntity stringEntity = new StringEntity(JSON.toJSONString((Object)request), ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)stringEntity);
        CloseableHttpResponse httpResponse = null;
        HttpEntity resEntity = null;
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            log.info("\u8bf7\u6c42\u4e50\u5237\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            resEntity = httpResponse.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            LeshuaBaseResponse<Object> response = new LeshuaBaseResponse<Object>();
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            response.setRespCode(jsonObject.getString("error_code"));
            response.setRespMsg(jsonObject.getString("error_msg"));
            String data = jsonObject.getString("data");
            if (StringUtils.isNotEmpty((CharSequence)data)) {
                response.setData(JSON.parseObject((String)data, request.getResponseClass()));
            }
            log.info("\u8bf7\u6c42\u4e50\u5237\u63a5\u53e3\u5165\u53c2:{} \u8bf7\u6c42\u4e50\u5237\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)request), response);
            leshuaBaseResponse = response;
        }
        catch (Exception e) {
            try {
                throw new LeshuaException("\u8c03\u7528\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                try {
                    EntityUtils.consume(resEntity);
                }
                catch (IOException e2) {
                    log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e2.getMessage(), (Throwable)e2);
                }
                if (httpResponse == null) throw throwable;
                try {
                    httpResponse.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume((HttpEntity)resEntity);
        }
        catch (IOException e) {
            log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        if (httpResponse == null) return leshuaBaseResponse;
        try {
            httpResponse.close();
            return leshuaBaseResponse;
        }
        catch (IOException e) {
            log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        return leshuaBaseResponse;
    }

    public static void main(String[] args) {
        Object[] music = new String[]{"Island", "Ocean", "Pretty", "Sun", ""};
        Scanner input = new Scanner(System.in);
        music[music.length - 1] = input.next();
        Arrays.sort(music);
        System.out.println(JSON.toJSONString((Object)music));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> LeshuaBaseResponse<T> executeHttp(LeshuaBizRequest<T> request, String url) throws LeshuaException {
        LeshuaBaseResponse<Object> leshuaBaseResponse;
        ValidateUtil.validateWithThrow(request, new Class[0]);
        log.info("\u4e50\u5237\u8bf7\u6c42\uff0crequest={}", (Object)JSON.toJSONString(request));
        HttpPost httppost = this.buildHttpPost(JSON.toJSONString(request), url);
        CloseableHttpResponse httpResponse = null;
        HttpEntity resEntity = null;
        log.info("\u4e50\u5237\u8bf7\u6c42\uff0chttppost={}", (Object)JSON.toJSONString((Object)httppost));
        CloseableHttpClient httpClient = null;
        try {
            httpClient = HttpClients.createDefault();
            httpResponse = httpClient.execute((HttpUriRequest)httppost);
            resEntity = httpResponse.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            log.info("\u4e50\u5237\u8fd4\u56de\uff0cresponse={}", (Object)responseStr);
            LeshuaBaseResponse<Object> response = new LeshuaBaseResponse<Object>();
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            response.setReqSerialNo(jsonObject.getString("reqSerialNo"));
            response.setRespCode(jsonObject.getString("respCode"));
            response.setRespMsg(jsonObject.getString("respMsg"));
            if (!StringUtils.isBlank((CharSequence)jsonObject.getString("data"))) {
                response.setData(JSON.parseObject((String)jsonObject.getString("data"), request.getResponseClass()));
            }
            leshuaBaseResponse = response;
        }
        catch (Exception e) {
            try {
                log.error("\u8c03\u7528\u4e50\u5237\u63a5\u53e3\u5f02\u5e38 error:{}", (Throwable)e);
                throw new LeshuaException("\u8c03\u7528\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                try {
                    EntityUtils.consume(resEntity);
                }
                catch (IOException e2) {
                    log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e2.getMessage(), (Throwable)e2);
                }
                if (httpResponse == null) throw throwable;
                try {
                    httpResponse.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume((HttpEntity)resEntity);
        }
        catch (IOException e) {
            log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        if (httpResponse == null) return leshuaBaseResponse;
        try {
            httpResponse.close();
            return leshuaBaseResponse;
        }
        catch (IOException e) {
            log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        return leshuaBaseResponse;
    }

    private HttpPost buildHttpPost(String request, String url) throws LeshuaException {
        String reqSerialNo = ReqSerialNoUtil.getReqSerialNo();
        String sign = LeshuaSignature.getRiskBase64Sign(this.privateKey, request);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setSocketTimeout(10000).setConnectTimeout(6000).build();
        HttpPost httppost = new HttpPost(this.serverUrl + url);
        httppost.setConfig(requestConfig);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntityBuilder.setCharset(Charset.forName("utf-8"));
        multipartEntityBuilder.addPart("agentId", (ContentBody)new StringBody(this.agentId, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("version", (ContentBody)new StringBody(VERSION, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("reqSerialNo", (ContentBody)new StringBody(reqSerialNo, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("data", (ContentBody)new StringBody(request, ContentType.APPLICATION_JSON));
        multipartEntityBuilder.addPart("sign", (ContentBody)new StringBody(sign, ContentType.APPLICATION_JSON));
        HttpEntity reqEntity = multipartEntityBuilder.build();
        httppost.setEntity(reqEntity);
        return httppost;
    }

    private LeshuaRiskClientImpl() {
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeshuaRiskClientImpl)) {
            return false;
        }
        LeshuaRiskClientImpl other = (LeshuaRiskClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeshuaRiskClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    public String toString() {
        return "LeshuaRiskClientImpl(serverUrl=" + this.getServerUrl() + ", agentId=" + this.getAgentId() + ", privateKey=" + this.getPrivateKey() + ", timeout=" + this.getTimeout() + ")";
    }
}

