/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantSettlePeriodCheckResponse;
import com.fshows.leshuapay.sdk.response.settlement.MerchantSettlePeriodQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 商户自定义结算周期查询
 *
 * @author wangyi
 * @version MerchantSettlePeriodCheckRequest.java, v 0.1 2023-08-03 10:03 wangyi
 */
@Data
public class MerchantSettlePeriodQueryRequest extends LeshuaBizRequest<MerchantSettlePeriodQueryResponse> {


    private static final long serialVersionUID = -8348589268536050933L;

    /**
     * 商户号
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantSettlePeriodQueryResponse> getResponseClass() {
        return MerchantSettlePeriodQueryResponse.class;
    }
}