/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.basic;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 更新参数来自乐刷文档：https://www.yuque.com/leshuazf/doc/dbmxyi#rj3DI
 *
 * @author zhaoyi
 * @version BankBranchRequest.java, v 0.1 2020-07-30 09:05 zhaoyi
 */
@Data
public class BankBranchRequest implements Serializable {

    private static final long serialVersionUID = 2849010730054156621L;

    /**
     * 联行号
     */
    private String unionpayCode;

    /**
     * 金融机构代码
     */
    private String finInstitutionCode;

    /**
     * 所在省份
     */
    private String bankArea;

    /**
     * 所在城市
     */
    private String bankCity;

    /**
     * 支行名称
     */
    private String branchName;

    /**
     * 所在省份国标编码
     */
    private String cftAreaCode;

    /**
     * 所在城市国标编码
     */
    private String cftCityCode;

    /**
     * 所在省份银行编码
     */
    private String unionAreaCode;

    /**
     * 所在城市银行编码
     */
    private String unionCityCode;

    /**
     * 页码
     */
    private Integer page;

    /**
     * 页码单页数量
     */
    private Integer pageSize;

    @Deprecated
    private String cftProvinceCode;

    @Deprecated
    private String cftProvinceName;

    @Deprecated
    private String cftCityName;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
