/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.client;

import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;

/**
 * @author linzy
 * @version LeshuaShareClient.java, v 0.1 2021-05-06 09:40 linzy
 */
public interface LeshuaShareClient {

    /**
     * 调用分账相关请求
     *
     * @param request 商户入参
     * @param url     实际业务请求地址
     * @param timeout 超时设置，单位毫秒
     * @param <T>
     * @return
     * @throws LeshuaException
     */
    <T> LeshuaBaseResponse<T> execute(LeshuaBizRequest<T> request, String url, Integer timeout) throws LeshuaException;

}
