/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 银联QRA商户上报信息
 *
 * @author zhaoyi
 * @version UnionpayQRAReportInfo.java, v 0.1 2020-07-29 15:25 zhaoyi
 */
@Data
public class UnionpayQRAReportInfo implements Serializable {

    private static final long serialVersionUID = 6611600274937591859L;
    /**
     * 银联QRA商户号（上报失败则为空）
     */
    private String subMchId;

    /**
     * 是否可用
     * 0 不可用
     * 1 可用
     */
    private String usable;

    /**
     * 上报失败时的失败原因
     */
    private String msg;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }


}
