/**
 * fshows.com Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.MerchantInfoUpdateShortnameResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 商户信息查询request
 *
 * @author zhaoyi
 * @version MerchantInfoQueryRequest.java, v 0.1 2020-07-30 11:59 zhaoyi
 */
@Data
public class MerchantUpdateShortnameRequest extends LeshuaBizRequest<MerchantInfoUpdateShortnameResponse> {

    /** 商户编号 */
    @NotBlank(message = "wxSubMchId不能为空")
    @Length(max = 10, message = "wxSubMchId超长")
    private String wxSubMchId;

    @Override
    public Class<MerchantInfoUpdateShortnameResponse> getResponseClass() {
        return MerchantInfoUpdateShortnameResponse.class;
    }
}
