/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant.expired;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * @author zhaoyi
 * @version MerchantWxPayConfigQueryResponse.java, v 0.1 2020-07-29 12:15 zhaoyi
 */
@Data
public class MerchantCardExpiredQueryResponse implements Serializable {

    private static final long serialVersionUID = 6842745738080117673L;

    /**
     * 证件信息
     */
    private String msg;
    /**
     * 0.证件正常,1.证件即将过期,2.证件已过期或者格式错误3.未知
     */
    private Integer code;
    /**
     * code=3 返回未知 其余返回 起始日期~结束日期  格式:yyyy-MM-dd
     */
    private String validDate;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
