/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LeshuaUtils {
    private static final Logger log = LoggerFactory.getLogger(LeshuaUtils.class);
    private static final String XML = "xml";
    private static Pattern UNDERLINE_PATTERN = Pattern.compile("[A-Z]");
    private static final List<String> IGNORE_FIELDS = CollectionUtil.newArrayList((Object[])new String[]{"pidInfo"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInput(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 0;
        byte[] buffer = new byte[1024];
        try {
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            out.close();
            in.close();
        }
        return out.toByteArray();
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        return baos.toString("utf-8");
    }

    public static InputStream getStringStream(String sInputString) throws UnsupportedEncodingException {
        ByteArrayInputStream tInputStringStream = null;
        if (sInputString != null && !sInputString.trim().equals("")) {
            tInputStringStream = new ByteArrayInputStream(sInputString.getBytes("utf-8"));
        }
        return tInputStringStream;
    }

    public static <Res> Res getObjectFromXML(String xml, Class<Res> tClass, String alias) throws Exception {
        Map<String, String> mapFromXML = LeshuaUtils.getMapFromXML(xml);
        return (Res)BeanUtil.toBean(mapFromXML, tClass);
    }

    public static Map<String, String> toMap(Object obj) {
        Field[] fields;
        ConcurrentSkipListMap<String, String> map = new ConcurrentSkipListMap<String, String>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            try {
                Object val;
                field.setAccessible(true);
                if (Modifier.isStatic(field.getModifiers()) || (val = field.get(obj)) == null) continue;
                String key = field.getName();
                map.put(LeshuaUtils.camelToUnderline(key), String.valueOf(val));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return map;
    }

    public static String calcExpireTime(Date now, String expireInMinutes, SimpleDateFormat dateFormat) {
        return dateFormat.format(now.getTime() + Long.parseLong(expireInMinutes) * 60L * 1000L);
    }

    public static String camelToUnderline(String str) {
        if (IGNORE_FIELDS.contains(str)) {
            return str;
        }
        Matcher matcher = UNDERLINE_PATTERN.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, String> getMapFromXML(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream is = LeshuaUtils.getStringStream(xmlString);
        Document document = builder.parse(is);
        NodeList allNodes = document.getFirstChild().getChildNodes();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Node node = allNodes.item(i);
            if (!(node instanceof Element)) continue;
            map.put(node.getNodeName(), node.getTextContent());
        }
        return map;
    }
}

