/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.activity;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.activity.LeshuaActivitySignResponse;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author zhangmj
 * @version LeshuaActivitySignRequest.java, v 0.1 2022-03-09 上午9:29 zhangmj
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LeshuaActivitySignRequest extends LeshuaBizRequest<LeshuaActivitySignResponse> {

    /**
     * 乐刷商户id
     */
    private String merchantId;
    /**
     * 支付宝子商户号
     */
    private String zfbSubMchId;
    /**
     * 营业执照图片地址
     */
    private String businessLicensePic;
    /**
     * 商户行业资质图片地址
     */
    private String industryQualificationImage;
    /**
     * 特殊费率对应的行业code
     */
    private String industryCode;
    /**
     * 机构跟银行的合作协议关键页/机构银行合作授权函
     */
    private String bankCooperationAgreement;
    /**
     * 银行开户证明/银行开户回单/委托代收党费党支部红头文件
     */
    private String bankAccountProve;
    /**
     * 结算卡号
     */
    private String cardNo;
    /**
     * 结算卡持卡人姓名
     */
    private String cardName;
    /**
     * 结算卡对应的支行名称
     */
    private String bankBranchName;
    /**
     * 收费样本
     */
    private String chargeSample;
    /**
     * 法人身份证正反面照
     */
    private String legalPersonPic;
    /**
     * 负责人授权函
     */
    private String legalPersonLicenseAuthPic;
    /**
     * 门头照
     */
    private String shopEntrancePic;
    /**
     * 店内环境照
     */
    private String indoorPic;
    /**
     * 活动类型
     */
    private String activityType;

    @Override
    public Class<LeshuaActivitySignResponse> getResponseClass() {
        return LeshuaActivitySignResponse.class;
    }
}