/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.rate;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 只有T1借记卡有封顶（maxCharge）,只有T0信用卡有提现费（fixedCharge）
 *
 * @author zhaoyi
 * @version FeeUnit.java, v 0.1 2020-07-30 9:17 zhaoyi
 */
@Data
public class FeeUnit implements Serializable {

    private static final long serialVersionUID = -8965515157958019459L;
    /**
     * 正常
     * 单位：万分之一,如60表示按0.6%收费
     */
    private Long rate;

    /**
     * 正常
     * 单位：万分之一分，如60,0000表示每笔交易最低收费0.6元
     */
    private Long minCharge;

    /**
     * 正常
     * 单位：万分之一分，如30,00,0000表示每笔交易最高收费30元，借记卡T1费率必填
     */
    private Long maxCharge;

    /**
     * 额外收费
     * 单位：万分之一分，如30,00,000表示每笔交易额外收费3元
     */
    private Long fixedCharge;

    /**
     * 额外收费
     * 单位：万分之一分，如10表示按0.1%收费,即每笔按交易量额外收费0.1%
     */
    private Long extRate;

    public FeeUnit(Long rate) {
        this.rate = rate;
    }

    public FeeUnit(Long rate, Long maxCharge) {
        this.rate = rate;
        this.maxCharge = maxCharge;
    }

    public FeeUnit() {
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
