/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.terminal;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.terminal.TerminalCollectResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 终端收集
 *
 * @author zhaoxumin
 * @version TerminalCollectRequest.java, v 0.1 2022-09-20 18:50 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class TerminalCollectRequest extends LeshuaBizRequest<TerminalCollectResponse> {
    private static final long serialVersionUID = 441198297071618845L;

    /**
     * 二代编号
     */
    private String subAgentId;

    /**
     * 乐刷商户号
     */
    @NotBlank
    private String merchantId;

    /**
     * 乐刷终端编号,不传serialNum时的修改与注销操作必传
     */
    private String deviceId;

    /**
     * 选填，指定子商户上报时传
     */
    private String subMchId;

    /**
     * 选填，默认A,T,U。如果指定上报子商户号，该子商户号要和channel匹配
     */
    private String channel;

    /**
     * 操作符，00:新增，01:修改 ,02:注销
     */
    @NotBlank
    private String operationId;

    /**
     * 设备类型
     */
    @NotBlank
    private String terminalType;

    /**
     * 新设备类型，259合规改造后的新设备类型，请用此类型
     */
    private String newTerminalType;

    /**
     * 终端状态，00:新增，01:注销
     */
    @NotBlank
    private String terminalState;

    /**
     * 选填，终端序列号，特定终端类型必填
     */
    private String serialNum;

    /**
     * 省编码，乐刷地区码
     */
    private String provinceNo;

    /**
     * 市编码，乐刷地区码
     */
    private String cityNo;

    /**
     * 区编码，乐刷地区码
     */
    private String areaNo;

    /**
     * 详细地址，30个字以内
     */
    private String terminalAddress;

    /**
     * 终端厂商名称
     */
    private String industryName;

    /**
     * 终端型号
     */
    private String industryModel;

    @Override
    public Class<TerminalCollectResponse> getResponseClass() {
        return TerminalCollectResponse.class;
    }
}
