/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.pay;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 乐刷退款request
 * @author xiaotian
 * @version LeshuaRefundRequest.java, v 0.1 2020-07-29 8:57
 */
@Data
public class LeshuaRefundRequest extends LeshuaBasePayRequest{

    /**
     * 接口名
     **/
    private String service = "unified_refund";

    /**
     * 乐刷分配商户号
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;


    /**
     * 商户订单号
     */
    private String thirdOrderId;

    /**
     * 乐刷订单号
     * 商户订单号跟乐刷订单号必填1个，优先使用leshua_order_id
     */
    private String leshuaOrderId;

    /**
     * 商户退款id
     * 可以包含字母（不能有“_”等特殊字符），确保同一商户下唯一
     */
    @NotBlank(message = "merchantRefundId不能为空")
    private String merchantRefundId;

    /**
     * 退款成功原样返回；注意：只能是汉字、英文字母、数字
     */
    private String attach;

    /**
     * 退款金额
     */
    @NotBlank(message = "refundAmount不能为空")
    private String refundAmount;

    /**
     * 接收乐刷退款结果通知的URL，需做Url Encode处理，需要绝对路径，确保乐刷能正确访问
     */
    private String notifyUrl;

    /**
     * 0：不使用账户余额退款，
     * 1：可以使用账户余额退款（优先使用正向交易抵扣，正向交易不够抵扣情况下可用账户余额进行退款）。
     * 2：限定只可以用账户余额进行退款
     * 不传默认不使用账户余额退款
     */
    private String refundType;
}

