/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.merchant.riskmanagement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchant.riskmanagement.RiskSettlementStatusQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 查询商户交易结算状态 Request
 *
 * @author liangyuanping
 * @version RiskSettlementStatusQueryRequest.java, v 0.1 2022-05-30 11:21 上午 liangyuanping
 */
@Data
public class RiskSettlementStatusQueryRequest extends LeshuaBizRequest<RiskSettlementStatusQueryResponse> {

    private static final long serialVersionUID = -3374534483505410731L;

    /**
     * 商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String merchantId;

    @Override
    public Class<RiskSettlementStatusQueryResponse> getResponseClass() {
        return RiskSettlementStatusQueryResponse.class;
    }
}