package com.fshows.leshuapay.sdk.request.settlement;/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantGetOrderSettleInfoResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author shijp
 * @version MerchantGetOrderSettleInfoRequest.java, v0.1 2022-01-17-7:27 下午 shijp
 */

@Data
public class MerchantGetOrderSettleInfoRequest extends LeshuaBizRequest<MerchantGetOrderSettleInfoResponse> {

    /**
    * 乐刷商户编号
    */
    @NotBlank(message = "乐刷商编不能为空")
    private String merchantId;

    /**
    * 乐刷交易订单号
    */
    @NotBlank(message = "乐刷交易订单号不能为空")
    private String orderId;

    /**
    * 交易类型[非必填]
     * 0：自动
     * 1：刷卡
     * 2：扫码
    */
    private String tradeType;

    @Override
    public Class<MerchantGetOrderSettleInfoResponse> getResponseClass() {
        return MerchantGetOrderSettleInfoResponse.class;
    }
}
