package com.fshows.leshuapay.sdk.request.repayment;

import lombok.Data;
import org.hibernate.validator.constraints.Range;

import java.io.Serializable;

/**
 * @author songjian * @version PageRequest.java, v 0.1 2025-04-17 14:35 songjian
 */
@Data
public class PageRequest implements Serializable {
    private static final long serialVersionUID = 6156290093233641037L;
    /**
     * 每页条数（1-30，超过30自动重置为30）
     */
    @Range(min = 1, max = 30, message = "pageSize取值范围1-30")
    private Integer pageSize = 10;

    /**
     * 当前页码（从1开始）
     */
    @Range(min = 1, message = "pageNo最小为1")
    private Integer pageNo = 1;
}
