package com.fshows.leshuapay.sdk.request.merchantreceipt;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.merchantreceipt.LeshuaMerchantReceiptResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

@Data
public class LeshuaMerchantReceiptRequest extends LeshuaBizRequest<LeshuaMerchantReceiptResponse> {
    private static final long serialVersionUID = -1224431650210254173L;

    /** 乐刷商户号 */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /** 打款单号（与日期范围二选一） */
    private String settleOrderNo;

    /** 打款开始日期（格式：YYYY-MM-DD） */
    //@Pattern(regexp = "^\\d{4}-\\d{2}-\\d{2}$", message = "日期格式必须为YYYY-MM-DD")
    private String startTime;

    /** 打款结束日期（格式：YYYY-MM-DD） */
    //@Pattern(regexp = "^\\d{4}-\\d{2}-\\d{2}$", message = "日期格式必须为YYYY-MM-DD")
    private String endTime;

    /** 图片类型（默认0） */
    @Range(min = 0, max = 3, message = "picType取值范围0-3")
    private Integer picType = 0;

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<LeshuaMerchantReceiptResponse> getResponseClass() {
        return LeshuaMerchantReceiptResponse.class;
    }
}
