/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * @author mengqf
 * @version MerchantInfoSupplementQueryResponse.java, v 0.1 2024-10-12 16:11 mengqf
 */
@Data
public class MerchantInfoSupplementQueryResponse implements Serializable {
    private static final long serialVersionUID = 5362942567735846796L;

    /**
     * 商编
     */
    private String merchantId;

    /**
     * 业务类型 ledger（分账）withdrawalAtOnce（提现秒到）withdrawal9hourBatch（提现9点批次）
     */
    private String businessType;

    /**
     * 审核状态：
     *  0-待审核
     * 1-审核通过
     * 2-审核不通过
     */
    private Integer status;

    /**
     * 审核拒绝原因
     */
    private String remark;
}