/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.AccreditResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 分账授权申请
 *
 * @author linzy
 * @version AccreditRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AccreditRequest extends LeshuaBizRequest<AccreditResponse> {

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 商户基础信息
     */
    private BaseInfo baseInfo;

    /**
     * 营业执照信息
     */
    private LicenseInfo licenseInfo;

    /**
     * 其它信息
     */
    private OtherInfo otherInfo;

    /**
     * 商户分账费率设置类型，枚举如下：
     * 1：首次签约开通分账并为商户设置分账费率；
     * 2：商户已开通分账未设置费率，要重新调用该接口为其设置费率。
     * 或商户已开通分账已设置费率，要重新调用该接口为其改费率。
     * 注：传2时，需要商家重新签署协议费率才能生效。
     */
    private Integer insertFlag;

    /**
     * 商户拟使用的分账方式
     * 1：订单分账
     * 2：余额分账
     * 4：品牌分账
     */
    private Integer ledgerMethod;

    /**
     * 品牌分账费率,JSON格式
     */
    private AccreditShareRateRequest feeRate2;

    @Override
    public Class<AccreditResponse> getResponseClass() {
        return AccreditResponse.class;
    }
}
