/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantOpenRealtimeSettleResponse;
import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.NotBlank;

/**
 * 实时入账配置 request
 *
 * @author zhaoyi
 * @version MerchantOpenRealtimeSettleRequest.java, v 0.1 2020-07-30 17:50 zhaoyi
 */
@Data
public class MerchantOpenRealtimeSettleRequest extends LeshuaBizRequest<MerchantOpenRealtimeSettleResponse> {

    private static final long serialVersionUID = 5589286331609647331L;

    /**
     * 乐刷商编
     */
    @NotBlank(message = "乐刷商编不能为空")
    private String merchantId;
    /**
     * 状态 0:关闭  1:开通
     */
    private String status;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantOpenRealtimeSettleResponse> getResponseClass() {
        return MerchantOpenRealtimeSettleResponse.class;
    }
}
