/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.leshuapay.sdk.client.impl;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.leshuapay.sdk.client.LeshuaGoldActivitySignClient;
import com.fshows.leshuapay.sdk.exception.LeshuaException;
import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import com.fshows.leshuapay.sdk.util.ValidateUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeshuaGoldActivitySignClientImpl
implements LeshuaGoldActivitySignClient {
    private static final Logger log = LoggerFactory.getLogger(LeshuaGoldActivitySignClientImpl.class);
    private static final int CONNECTION_REQUEST_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final String VERSION = "1.0";
    private static CloseableHttpClient httpclient = HttpClients.createDefault();
    private String agentId;
    private String privateKey;
    private String serverUrl;
    private Integer timeout;

    public LeshuaGoldActivitySignClientImpl(String agentId, String privateKey, String serverUrl, Integer timeout) {
        this.agentId = agentId;
        this.privateKey = privateKey;
        this.serverUrl = serverUrl;
        this.timeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> LeshuaBaseResponse<T> execute(LeshuaBizRequest<T> request, String url) throws Exception {
        LeshuaBaseResponse<Object> leshuaBaseResponse;
        ValidateUtil.validateWithThrow(request, new Class[0]);
        RequestConfig requestConfig = null;
        requestConfig = this.timeout == null || this.timeout <= 0 ? RequestConfig.custom().setConnectionRequestTimeout(10000).setSocketTimeout(10000).setConnectTimeout(10000).build() : RequestConfig.custom().setConnectionRequestTimeout(this.timeout.intValue()).setSocketTimeout(this.timeout.intValue()).setConnectTimeout(this.timeout.intValue()).build();
        HttpPost httpPost = new HttpPost(this.serverUrl + url);
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Content-Type", "application/json;charset=utf-8");
        httpPost.setEntity((HttpEntity)new StringEntity(JSON.toJSONString(request), StandardCharsets.UTF_8));
        CloseableHttpResponse httpResponse = null;
        HttpEntity resEntity = null;
        try {
            httpResponse = httpclient.execute((HttpUriRequest)httpPost);
            resEntity = httpResponse.getEntity();
            String responseStr = EntityUtils.toString((HttpEntity)resEntity, (String)"utf-8");
            log.info("\u4e50\u5237\u6d3b\u52a8\u62a5\u540d_\u4e50\u5237\u63a5\u53e3\u8bf7\u6c42\u8fd4\u56de param={}; response={}", (Object)JSON.toJSONString(request), (Object)responseStr);
            LeshuaBaseResponse<Object> response = new LeshuaBaseResponse<Object>();
            JSONObject jsonObject = JSON.parseObject((String)responseStr);
            response.setRespCode(jsonObject.getString("respCode"));
            response.setRespMsg(jsonObject.getString("respMsg"));
            String data = jsonObject.getString("data");
            if (StringUtils.isNotEmpty((CharSequence)data)) {
                response.setData(JSON.parseObject((String)data, request.getResponseClass()));
            }
            log.info("\u4e50\u5237\u6d3b\u52a8\u62a5\u540d_\u8bf7\u6c42\u4e50\u5237\u63a5\u53e3\u5165\u53c2:{} \u4e50\u5237\u6d3b\u52a8\u62a5\u540d_\u8bf7\u6c42\u4e50\u5237\u63a5\u53e3\u8fd4\u56de\u53c2\u6570:{}", (Object)JSON.toJSONString(request), response);
            leshuaBaseResponse = response;
        }
        catch (Exception e) {
            try {
                log.error("\u4e50\u5237\u6d3b\u52a8\u62a5\u540d_\u8c03\u7528\u5931\u8d25 param={} e={}", (Object)JSON.toJSONString((Object)httpPost), (Object)ExceptionUtil.getSimpleMessage((Throwable)e));
                throw new LeshuaException("\u4e50\u5237\u6d3b\u52a8\u62a5\u540d_\u8c03\u7528\u5931\u8d25", e);
            }
            catch (Throwable throwable) {
                try {
                    EntityUtils.consume(resEntity);
                }
                catch (IOException e2) {
                    log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e2.getMessage(), (Throwable)e2);
                }
                if (httpResponse == null) throw throwable;
                try {
                    httpResponse.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e3.getMessage(), (Throwable)e3);
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume((HttpEntity)resEntity);
        }
        catch (IOException e) {
            log.error("\u91ca\u653eHttpEntity\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        if (httpResponse == null) return leshuaBaseResponse;
        try {
            httpResponse.close();
            return leshuaBaseResponse;
        }
        catch (IOException e) {
            log.error("\u5173\u95edHttpResponse\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
        }
        return leshuaBaseResponse;
    }

    private LeshuaGoldActivitySignClientImpl() {
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeshuaGoldActivitySignClientImpl)) {
            return false;
        }
        LeshuaGoldActivitySignClientImpl other = (LeshuaGoldActivitySignClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$privateKey = this.getPrivateKey();
        String other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$serverUrl = this.getServerUrl();
        String other$serverUrl = other.getServerUrl();
        if (this$serverUrl == null ? other$serverUrl != null : !this$serverUrl.equals(other$serverUrl)) {
            return false;
        }
        Integer this$timeout = this.getTimeout();
        Integer other$timeout = other.getTimeout();
        return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeshuaGoldActivitySignClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $serverUrl = this.getServerUrl();
        result = result * 59 + ($serverUrl == null ? 43 : $serverUrl.hashCode());
        Integer $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        return result;
    }

    public String toString() {
        return "LeshuaGoldActivitySignClientImpl(agentId=" + this.getAgentId() + ", privateKey=" + this.getPrivateKey() + ", serverUrl=" + this.getServerUrl() + ", timeout=" + this.getTimeout() + ")";
    }
}

