/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.request.settlement;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.settlement.MerchantWithdrawApplyResponse;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @author youmingming
 * @version merchantWithdrawApply.java, v 0.1 2021-03-31 11:57 上午 youmingming
 */
@Data
public class MerchantWithdrawApplyRequest extends LeshuaBizRequest<MerchantWithdrawApplyResponse> {

    /**
     * 需要提现的乐刷商户号
     */
    private String merchantId;

    /**
     * 提现流水号，不能重复，否则提现失败;长度限制：10-36
     */
    @Size(min = 10, max = 36, message = "提现流水号格式不正确")
    private String reqId;

    /**
     * 提现金额，单位：分
     */
    @Min(value = 1, message = "提现金额需要大于0.01元")
    @NotNull
    private Integer applyAmount;

    /**
     * 1: 提 现 固 定 批 次 审 核 打 款   2 :提现秒到
     * （不填默认为1）
     */
    private Integer type;


    /**
     * Getter method for property <tt>responseClass</tt>.
     *
     * @return property value of responseClass
     */
    @Override
    public Class<MerchantWithdrawApplyResponse> getResponseClass() {
        return MerchantWithdrawApplyResponse.class;
    }
}