/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * 商户提现实时到账权限查询接口 response
 *
 * @author linzy
 * @version MerchantQueryQuickWithdrawResponse.java, v 0.1 2022-02-318 16:50 linzy
 */
@Data
public class MerchantQueryQuickWithdrawResponse implements Serializable {

    private static final long serialVersionUID = -5080053139120363842L;

    /**
     * 乐刷商编
     */
    private String merchantId;
    /**
     * 单日笔数
     */
    private Integer businessVolumeDaily;
    /**
     * 单笔最低限额,单位分
     */
    private Integer quotaMinOnce;
    /**
     * 是否开启了实时提现功能：0：否，1：是
     */
    private String state;
    /**
     * 单笔最高限额,单位分
     */
    private String quotaMaxOnce;
}
