/**
 * @author: cll
 * @version:1.0
 * @date: 2021-08-12 15:28
 * @descripton:
 */
package com.fshows.leshuapay.sdk.response.merchant.riskmanagement;

import lombok.Data;

import java.io.Serializable;

/**
 * 商户风控列表返回
 *
 * @author cll
 * @version RiskDetailResponse.java, v 0.1 2021-08-12 15:28 cll
 */
@Data
public class RiskDetailResponse implements Serializable {
    private static final long serialVersionUID = -5632058923180787323L;
    /**
     * 微信支付宝申诉方式 1--我司协助申诉;2--商户/代理商自行申诉;3-其他
     */
    private Integer fAppealType;
    /**
     * 申诉资料审核状态 1--待提交;2--审核中;3--审核未通过; 4--审核通过;5--审核终止;6--放弃提交,转线下审核
     */
    private Integer fMtlVerifyStatus;
    /**
     * 资料审核次数
     */
    private Integer fMtlVerifyTimes;
    /**
     * 是否禁止交易; 1--是;2--否
     */
    private Integer fProhibitTxn;
    /**
     * 备注
     */
    private String fRemark;
    /**
     * 风险等级;一~六级
     */
    private Integer fRiskLevel;
    /**
     * 最新操作人
     */
    private String fLastOperatorName;
    /**
     * 人工申诉结果凭证URL集合
     */
    private String fManualAppealEvidence;
    /**
     * 微信/支付宝人工申诉结果 1--待申诉;2--成功; 3--失败;4--其他
     */
    private Integer fManualAppealResult;
    /**
     * 商户名称
     */
    private String fMerchantName;
    /**
     * 交易类型;1-刷卡/快捷;2-扫码
     */
    private Integer fMerchantTxnType;
    /**
     * 结算状态
     */
    private String fDealStateStr;
    /**
     * 工单状态
     */
    private Integer fTicketStatus;
    /**
     * 乐刷商户编号
     */
    private String fMerchantId;
    /**
     * 工单编号
     */
    private String fTicketNumber;
    /**
     * 商户人工申诉失败原因
     */
    private String fManualFailureReason;
    /**
     * 申诉资料类型 1--扫码交易,真实商户,云闪付/乐刷/微信投诉来源申诉资料; 2--扫码交易,微信违规来源申诉资料; 3--扫码交易,支付宝来源申诉资料;
     * 4--扫码交易,微信违规申诉失败,转向乐刷解冻申诉资料; 5--刷卡/快捷交易,真实和非真实商户,云闪付和乐刷来源申诉资料; 6--扫码交易,非真实商户,云闪付/乐刷/微信投诉来源申诉资料;
     * 7--微信违规/支付宝风险来源转人工申诉,申诉结果凭证; 8--微信违规/支付宝风险来源选择不提交资料转线下审核,运营审核提交资料
     */
    private Integer fAppealInfoType;
    /**
     * T+1结算状态
     */
    private Integer fNextStatus;
    /**
     * 风险来源类型ID
     */
    private Integer fRiskType;
    /**
     * 风险来源类型
     */
    private String fRiskTypeStr;
    /**
     * 指定的三笔订单信息
     */
    private String fSpeMrtOrders;
    /**
     * 风险来源; 1--微信投诉;2--微信违规;3--支付宝违规; 4--云闪付;5--乐刷；6-支付宝告警
     */
    private Integer fRiskSource;
    /**
     * 禁止结算类型 1--禁止部分金额结算;2--禁止T+1结算;3--禁止T+0结算; 4--同时禁止T+1和T+0结算;5--不禁止任何结算
     */
    private Integer fProhibitSettlType;
    /**
     * 禁止结算原因
     */
    private String fProhibitSettlReason;
    /**
     * 禁止的交易订单
     */
    private String fProhibitOrders;
    /**
     * 代理商分类 7-聚合代理商
     */
    private Integer fAgentClass;
    /**
     * T+0结算状态：
     */
    private Integer fThatStatus;
    /**
     * 总数
     */
    private Integer totalCount;
}
