/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.response.merchant;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 商户微信实名认证-查询response
 *
 * @author zhaoyi
 * @version MerchantWxCertificationQueryResponse.java, v 0.1 2020-07-29 12:15 zhaoyi
 */
@Data
public class MerchantWxCertificationQueryResponse implements Serializable {

    private static final long serialVersionUID = -3353530187829029101L;

    private String merchantId;

    /**
     * 当前状态
     * WAIT_FOR_UPLOAD_DATA: 等待上送资料
     * UPLOAD_DATA_FAIL: 上送资料失败
     * APPLYMENT_STATE_WAITTING_FOR_AUDIT: 微信审核中
     * APPLYMENT_STATE_WAITTING_FOR_CONFIRM_CONTACT: 待确认联系信息
     * APPLYMENT_STATE_WAITTING_FOR_CONFIRM_LEGALPERSON: 待账户验证
     * APPLYMENT_STATE_PASSED: 审核通过
     * APPLYMENT_STATE_REJECTED: 审核驳回
     * APPLYMENT_STATE_FREEZED: 已冻结
     * APPLYMENT_STATE_CANCELED: 已作废
     */
    private String applyStatus;

    /**
     * 确认二维码
     * 确认二维码临时路径(10分钟有效，请自行保存)
     */
    private String qrcodeData;

    /**
     * 退回参数
     */
    private String rejectParam;

    /**
     * 退回原因
     */
    private String rejectReason;


    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
