/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.terminal;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.terminal.QueryMerchantChannelTerminalsResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 终端收集
 *
 * @author zhaoxumin
 * @version TerminalCollectRequest.java, v 0.1 2022-09-20 18:50 zhaoxumin
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryMerchantChannelTerminalsRequest extends LeshuaBizRequest<QueryMerchantChannelTerminalsResponse> {
    private static final long serialVersionUID = -2219430658074429838L;
    /**
     * 乐刷商户号
     */
    @NotBlank
    private String merchantId;

    /**
     * 二选一选填，乐刷终端编号
     */
    private String deviceId;

    /**
     * 二选一TUSN
     */
    private String serialNum;


    @Override
    public Class<QueryMerchantChannelTerminalsResponse> getResponseClass() {
        return QueryMerchantChannelTerminalsResponse.class;
    }
}
