/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.LeshuaBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 分账权限修改
 *
 * @author linzy
 * @version UpdateLedgerMethodRequest.java, v 0.1 2022-08-18 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UpdateLedgerMethodRequest extends LeshuaBizRequest<LeshuaBaseResponse> {

    /**
     * 商户号
     * 由乐刷分配
     */
    @NotBlank(message = "merchantId不能为空")
    private String merchantId;

    /**
     * 订单分账开关状态 0-关；1-开
     */
    private Integer orderLedgerState;

    /**
     * 余额分账开关状态 0-关；1-开
     */
    private Integer collectLedgerState;

    @Override
    public Class<LeshuaBaseResponse> getResponseClass() {
        return LeshuaBaseResponse.class;
    }
}
