/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.share;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import com.fshows.leshuapay.sdk.response.share.QueryBindResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * 分账授权结果查询
 *
 * @author linzy
 * @version BindRequest.java, v 0.1 2021-05-06 11:50 linzy
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryBindRequest extends LeshuaBizRequest<QueryBindResponse> {

    /**
     * 商户号
     * 关联方（其一）的编号，分账出资方
     */
    @NotBlank(message = "merchantId1不能为空")
    private String merchantId1;

    @Override
    public Class<QueryBindResponse> getResponseClass() {
        return QueryBindResponse.class;
    }
}
