/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.rate;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;

/**
 * 微信扫码费率
 *
 * @author zhaoyi
 * @version WxRate.java, v 0.1 2020-07-30 9:37 zhaoyi
 */
@Data
public class WxRate implements Serializable {


    private static final long serialVersionUID = -4256541321118222032L;

    /**
     * 微信扫码次日结算费率(开通扫码支付必传)
     */
    private FeeUnit t1;

    /**
     * 绿洲活动费率
     */
    private FeeUnit oasis;

    /**
     * 公益
     */
    private FeeUnit publicWeal;

    /**
     * 高校食堂
     */
    private FeeUnit collegeCanteen;

    /**
     * publicPayment
     */
    private FeeUnit publicPayment;

    /**
     * 私立学校
     */
    private FeeUnit privateSchool;

    /**
     * 保险
     */
    private FeeUnit insurance;

    /**
     * 线上
     */
    private FeeUnit online;

    /**
     * 微信扫码T0结算费率
     */
    private FeeUnit t0;

    /**
     * 服饰日化借记卡
     */
    private FeeUnit categoryDebit;

    /**
     * 服饰日化贷记卡
     */
    private FeeUnit categoryCredit;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
