/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.pay;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 微信刷脸response
 *
 * @author zhaoyi
 * @version LeshuaWxPayFaceResponse.java, v 0.1 2020-07-29 09:50 zhaoyi
 */
@Data
public class LeshuaWxPayFaceResponse extends LeshuaBasePayResponse {

    private static final long serialVersionUID = 5981051366670322612L;

    /**
     * SDK调用凭证
     * 用于调用 SDK 的人脸识别接口
     */
    private String authInfo;

    /**
     * authinfo有效时间
     * 单位秒
     */
    private String expiresIn;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
