/**
 * fshows.com
 * Copyright (C) 2013-2020 All Right Reserved
 */
package com.fshows.leshuapay.sdk.request.merchant.settlement;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 微信信息
 *
 * @author zhaoyi
 * @version WechatInfo.java, v 0.1 2020-07-27 15:10 zhaoyi
 */
@Data
public class WechatInfo implements Serializable {

    private static final long serialVersionUID = -8839700932086248321L;

    /**
     * 联系人微信号
     */
    private Integer userWx;

    /**
     * 微信公众号支付appid
     */
    @Length(max = 18, message = "微信公众号支付appid超长")
    private String subAppid;

    /**
     * 微信公众号授权目录 (只能配置1个)
     */
    private String jsapiPath;

    /**
     * 微信公众号支付完成后推荐关注appid (此处的推荐关注对应上方支付appid)
     */
    @Length(max = 18, message = "推荐关注appid超长")
    private String subscribeAppid;

    /**
     * 分店进件可使用微信_商户全称(与总店全称一致)上报微信。
     */
    @Length(max = 40, message = "微信商户全称超长")
    private String wxMchName;

}
