/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * @author youmingming
 * @version LeshuaSettlementApiEnum.java, v 0.1 2020-11-02 8:31 下午 youmingming
 */
public enum LeshuaSettlementApiEnum {
    /**
     * 结算接口
     */
    API_SETTLEMENT_ORDER("商户打款单结果查询", "/open-api/agent/settlement-order"),
    API_MERCHANT_DATE_SETTLEMENT_ORDER("查询商户指定日期打款情况", "/open-api/agent/merchant-settlement-order"),
    API_AGENT_FAIL_SETTLEMENT_ORDER("查询旗下商户打款失败明细", "/open-api/agent/agent-fail-settlement-order"),
    API_MERCHANT_WITHDRAW_APPLY("账户提现申请接口", "/open-api/merchant-withdraw/apply"),
    API_MERCHANT_WITHDRAW_BALANCE_QUERY("账户余额查询接口", "/open-api/merchant-withdraw/balance-query"),
    API_OPEN_REALTIME_SETTLE("实时入账配置接口", "/merchant/openRealtimeSettle"),
    API_OPEN_QUICK_WITHDRAW("商户提现实时到账权限设置接口", "/cashout/update"),
    API_QUERY_QUICK_WITHDRAW("商户提现实时到账权限查询接口", "/cashout/get"),
    API_CHECK_QUICK_WITHDRAW("商户提现实时到账权限检测接口", "/cashout/check"),
    API_GET_ORDER_SETTLE_INFO("实时入账订单清分计费查询", "/merchant/getOrderSettleInfo"),
    API_SET_MERCHANT_WITHDRAW_FEE("商户账户提现费率设置接口", "/cashout/setMerchantFee"),
    ;

    private String name;
    private String value;

    LeshuaSettlementApiEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static LeshuaSettlementApiEnum getByValue(String value) {
        LeshuaSettlementApiEnum[] valueList = LeshuaSettlementApiEnum.values();
        for (LeshuaSettlementApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }
}