/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * @author youmingming
 * @version MerchantWithdrawBalanceQueryResponse.java, v 0.1 2021-04-01 11:20 上午 youmingming
 */
@Data
public class MerchantWithdrawBalanceQueryResponse implements Serializable {

    private static final long serialVersionUID = -502273547897730593L;

    /**
     * 乐刷商户号
     */
    private String merchantId;

    /**
     * 账户余额
     * 当前商户虚拟账户的余额
     */
    private Integer balanceAmount;

    /**
     * 冻结金额
     * 当前商户虚拟账户的冻结金额。提现申请成功后会冻结金额
     */
    private Integer frozenAmount;

    /**
     * 止付金额
     * 当前商户虚拟账户的止付金额
     */
    private Integer suspendAmount;

    /**
     * 账户状态
     * 账户状态 1-正常 2-异常 3-冻结
     */
    private Integer accountState;

    /**
     * 可用余额
     * 当前商户虚拟账户的可用余额，提现需基于可用余额进行提现
     */
    private Integer contributoryAmount;

    /**
     * 已拦截金额
     */
    private Integer interceptAmount;
}