/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.response.pay;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @author zhaoyi
 * @version LeshuaScanCardPayResponse.java, v 0.1 2020-07-29 11:00 zhaoyi
 */
@Data
public class LeshuaScanCardPayResponse extends LeshuaBasePayResponse {

    private static final long serialVersionUID = 5897152446779649388L;

    /**
     * 乐刷商户号
     **/
    private String merchantId;

    /**
     * 通道商户号
     * 微信、支付宝、QRC商户号
     */
    private String subMerchantId;

    /**
     * 商户订单号
     * 商户内部订单号
     **/
    private String thirdOrderId;

    /**
     * 订单状态
     */
    private String status;

    /**
     * 乐刷订单号
     **/
    private String leshuaOrderId;

    /**
     * 支付类型
     **/
    private String payWay;

    /**
     * 支付完成时间
     * 支付成功时才返回
     */
    private String payTime;

    /**
     * 银行类型
     * 使用银行卡支付以外的（如零钱）全部展示为others
     */
    private String bankType;

    /**
     * 用户openid
     * 支付成功时才返回
     */
    private String openid;

    /**
     * 微信、支付宝等订单号
     * 支付成功时才返回
     */
    private String outTransactionId;

    /**
     * 用户子标识
     * 支付成功时才返回。微信：公众号APPID下用户唯一标识；支付宝：买家的支付宝用户ID
     */
    private String subOpenid;

    /**
     * 附加数据
     * 支付成功原样返回；注意：只能是汉字、英文字母、数字
     */
    private String attach;

    /**
     * 交易类型
     * 支付成功时才返回：MICROPAY-条码支付，NATIVE-原生扫码支付，JSAPI-公众号支付、服务窗支付，SmPgPay-小程序支付，JSAPIQuick-简易支付
     */
    private String tradeType;

    /**
     * 通道订单号
     * 支付成功时才返回
     */
    private String channelOrderId;

    /**
     * 通道订单时间
     * 支付成功时才返回
     */
    private String channelDatetime;

    /**
     * 支付宝红包金额
     * 支付成功时才返回，单位(分)
     */
    private String coupon;

    /**
     * 应结算金额
     * 实际结算金额，支付成功时才返回，单位(分)
     */
    private String settlementAmount;

    /**
     * 折扣优惠金额
     * 订单优惠金额，支付成功时才返回，单位(分)
     */
    private String discountAmount;

    /**
     * 优惠详情
     * 银联单品的具体优惠详情；
     * 微信优惠详情说明：微信官网
     */
    private String promotionDetail;

    /**
     * 活动标志。WXLZ：微信绿洲；ZFBLH：支付宝蓝海
     */
    private String activeFlag;

    /**
     * 买家实付金额
     * 微信、支付宝此值有效
     */
    private String buyerPayAmount;

    /**
     * 请求耗时
     * 请求接口耗费的时间
     */
    private String costTime;

    /**
     * 支付宝特有参数
     */
    private String alipayInfos;

    /**
     * 通道标识
     * GXST：高校食堂
     * PUBWEL：公益
     * PUBPAY：公缴
     * ZFBLH：支付宝新蓝海
     * SLZXY：私立中小幼
     * INS：保险
     * ONLINE：线上
     */
    private String channelFlag;

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this,
                ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
