package com.fshows.leshuapay.sdk.response.bill;

import com.fshows.leshuapay.sdk.request.LeshuaBizRequest;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author huanghai
 * @version 1.0 AgentInvoiceListRequest
 * @date 2021/11/23 16:48
 */
@Data
public class AgentInvoiceListResponse implements Serializable {
    private static final long serialVersionUID = -446664125887648837L;

    /**
     * 记录id
     */
    private Integer id;

    /**
     * 商户编号
     */
    private String merchantId;
    /**
     * 商户名称
     */
    private String merchantName;

    /**
     * 直属代理商编号
     */
    private String agentId;
    /**
     * 一级代理商编号
     */
    private String agentId1g;
    /**
     * 开票金额 单位：分
     */
    private Integer amount;

    /**
     * 记录生成时间
     */
    private String createTime;
    /**
     * 费用明细
     */
    private String  feeDetail;
    /**
     * 开票类型 0:交易手续费 1:其他
     */
    private Integer feeType;

}
