/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.leshuapay.sdk.enums;

/**
 * 商户号支付类型枚举
 *
 * @author zhaoyi
 * @version SubMchTypeEnum.java, v 0.1 2020-08-03 14:36 zhaoyi
 */
public enum SubMchTypeEnum {
    WX(1, "微信"),
    ALI_PAY(2, "支付宝"),
    UNION(3, "银联"),
    ;

    private Integer type;
    private String desc;

    SubMchTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SubMchTypeEnum getByType(Integer type) {
        SubMchTypeEnum[] valueList = SubMchTypeEnum.values();
        for (SubMchTypeEnum v : valueList) {
            if (v.getType().equals(type)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>type</tt>.
     *
     * @return property value of type
     */
    public Integer getType() {
        return type;
    }

    /**
     * Getter method for property <tt>desc</tt>.
     *
     * @return property value of desc
     */
    public String getDesc() {
        return desc;
    }
}
